#ifndef CE2_TST_RC4_H
#define CE2_TST_RC4_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif


/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wen Mar 14 10:17:10 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_RC4.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines *******************************/
#define TST_NAME_STRING_LEN 150
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS 1536
//#define TST_CBC_MAC_SIZE 16
//#define TST_KEYWRAP_IV_SIZE_IN_BYTES 8
//#define TST_FUNC_STRING_LEN 100
//#define TST_ENCRYPT 0
//#define TST_MAX_SINGLE_AES_BLOCK_SIZE_IN_BYTS 16

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/

typedef struct TST_RC4_TestDataStruct{	
  char					    TST_Name[TST_NAME_STRING_LEN];
  DxUint8_t 					TST_Key[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint16_t					TST_KeySize;
  DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint8_t 					TST_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint8_t 					TST_Expected_output_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
  DxUint16_t					TST_dataSize;	
} TST_RC4_TestDataStruct;

/************************ Public Variables **********************/

extern TST_RC4_TestDataStruct TST_RC4_Acceptance_TestData[];
extern const int TST_NumberOf_RC4AcceptanceTests;

/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_RC4_Acceptance_integrated 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for RC4 non integrated API's							
* 	This function Encryprts and Decrypts known vectors using RC4 
* 	Vector sizes used (in bytes) - 16/32/45/512/1536									
* 	Key Size used (in bytes)	- 16/32/45/512								
* 	This also outputs the results to an output buffer or the same input buffer
* Algorithm:		
* 1. Call the CE2_RC4_to Preform the encryprion/decryption process
* 2. Compare the outputted result to the expected one													
*
******************************************************************************/	
CE2Error_t CE2_ATP_TST_RC4_Acceptance_Integrated (FILE* out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_RC4_H */
